
Class SpaceGem

	Public
	
	Property Collected:Bool ()
		Return collected
		Setter (value:Bool)
			collected = value
	End
	
	Method New (x:Float, y:Float, z:Float, size:Float = 1.0, color:Color = Null)
	
		If Not GemList Then GemList = New List <SpaceGem>
		
		If Not CollectedSound Then CollectedSound = Sound.Load ("asset::collected.ogg")
		
		Local box:Boxf = New Boxf (-size * 0.5, -size * 0.5, -size * 0.5, size * 0.5, size * 0.5, size * 0.5)
		
		If Not color Then color = Color.Red
		
		model = Model.CreateBox (box, 1, 1, 1, New PbrMaterial (color))
		Cast <PbrMaterial> (model.Material).MetalnessFactor = 1.0

'		light = New Light (model)
'		light.Type = LightType.Spot
'		light.Rotate (90.0, 0.0, 0.0) ' Spotlight down
'		light.InnerAngle = 0.0
'		light.OuterAngle = 45.0
'		light.CastsShadow = True
'		light.Color = color * 4.0
'		light.Range = 15.0
'
		model.Move (x, y + size * 3.0, z)
		model.Alpha = 0.5
'		model.Rotate (Rnd (45.0), Rnd (45.0), Rnd (45.0))

		collider = model.AddComponent <BoxCollider> ()
		collider.Box = box

		body = model.AddComponent <RigidBody> ()
		body.Mass = 1.0
		body.AngularDamping = 0.0
		body.btBody.setCollisionFlags (bullet.btCollisionObject.CF_NO_CONTACT_RESPONSE)

		body.CollisionMask	= COLL_GEM
		body.CollisionGroup	= GEM_COLLIDES_WITH
		
		model.Collided += Lambda (other_body:RigidBody)
			Collected = True
		End
		
		GemList.AddLast (Self)
		
	End
	
	Method Destroy ()
		model?.Destroy ()
		If body Then body = Null
		GemList.Remove (Self)
	End
	
	Function Start ()

		If SpaceGem.GemList
			For Local sg:SpaceGem = Eachin SpaceGem.GemList
				sg.body.ApplyTorqueImpulse (New Vec3f (1.0, 2.0, 4.0))
			Next
		Endif

	End
	
	Function Update ()

		If SpaceGem.GemList
		
			For Local sg:SpaceGem = Eachin SpaceGem.GemList
				
				' Not sure why -0.5 works... -1.0 worked when called in Game.Update!
				
				sg.body.ApplyForce (Game.GameScene.World.Gravity * New Vec3f (1.0, -0.5, 1.0))
				
				If sg.Collected

					sg.Destroy ()

					SpaceGem.Collected_Channel = SpaceGem.CollectedSound.Play (False)
					SpaceGem.Collected_Channel.Volume = 0.5
					Game.CurrentLevel.SpaceGemCollected ()

				Endif
				
			Next
		

'				sg.ApplyForce (GameScene.World.Gravity * New Vec3f (1.0, -1.0, 1.0))
				
'				sg.model.Rotate (2.0, 2.0, 2.0)
				
'				If sg.model.Position.Distance (Game.Player.RocketModel.Position) < 4.0
					
'					If SpaceGem.Collected
					
'						SpaceGem.Collected_Channel = SpaceGem.Collected.Play (False)
'						SpaceGem.Collected_Channel.Volume = 0.5
						
'						Game.CurrentLevel.SpaceGemCollected ()
						
'					Endif
					
'					sg.model?.Destroy ()
'					SpaceGem.SpaceGemList.Remove (sg)
'					
'				Endif
			
		Endif

	End

	Private

	Global GemList:List <SpaceGem>
	
	Global CollectedSound:Sound
	Global Collected_Channel:Channel
	
	Field model:Model
	Field body:RigidBody			' Bullet physics body
	Field collider:BoxCollider		' Bullet physics collider

	Field light:Light
	
	Field collected:Bool = False
	
End
